/// EnemyStateFollow()

if (instance_exists(target)) {
	//Log(string(id)+" is following");
	var distance_to_target  = point_distance(x, y, target.x, target.y);
	if (distance_to_target  < 10 * GRID_SIZE &&
		y - GRID_SIZE * 1.0 < target.y &&
		y + GRID_SIZE * 2.5	> target.y) {
		
		// move towards the target
		var direction_to_target = sign(target.x - x);
		if (direction_to_target > 0 && xSpeed < maxRunSpeed)
			xSpeed += accel;
		else if (direction_to_target < 0 && xSpeed > -maxRunSpeed)
			xSpeed -= accel;
		// Update the facing direction
		image_xscale = direction_to_target;
		
		// attack if the player is close enough
		if (distance_to_target < 3 * GRID_SIZE && distance_to_target > GRID_SIZE * 1.5 && attackCooldown <= 0) {
			state = enemyState.attack;
		}
	} else {
		// go to idle if lost the target
		state = enemyState.idle;
	}
}
